function [sigma_breve_plot,y_breve_plot] = ...
    fault_slip_sigma_breve_plot(ddelta_dy,dy,flag_merged,G,nu,xi,y_delta,y_tilde)
%
% Computes stresses at the fault as a result of fault slip to generate plots.
% Makes frequent use of fault_slip_sigma_breve.

if flag_merged == 0 % slip patches have not yet merged
    % Recover grid info (see fault_slip_delta.m for definitions):
    help_01 = y_delta(2:end-1);
    help_02 = help_01 < 0;
    help_03 = help_01 > 0;
    y_bot = help_01(help_02);
    y_top = help_01(help_03);
    n_y_bot = length(y_bot);
    ddelta_dy_bot = ddelta_dy(2:n_y_bot+1);
    ddelta_dy_top = ddelta_dy(n_y_bot+2:end-1);
    dy_bot = dy(1:n_y_bot);
    dy_top = dy(n_y_bot+1:end);
    n_xi_bot = n_y_bot+2;
    xi_bot = xi(1:n_xi_bot);
    xi_top = xi(n_xi_bot+1:end);

    % Compute slip-induced stresses:    
% % %     [sigma_breve_bot_1,y_breve_bot_1] = fault_slip_sigma_breve(ddelta_dy_bot,dy_bot,G,...
% % %         200,nu,y_bot,y_tilde(1),-250);
% % %     [sigma_breve_bot_2,y_breve_bot_2] = fault_slip_sigma_breve(ddelta_dy_bot,dy_bot,G,...
% % %         1,nu,y_bot,xi_bot,xi_bot);
% % %     [sigma_breve_bot_3,y_breve_bot_3] = fault_slip_sigma_breve(ddelta_dy_bot,dy_bot,G,...
% % %         20,nu,y_bot,0,y_tilde(2));   
% % %     [sigma_breve_top_1,y_breve_top_1] = fault_slip_sigma_breve(ddelta_dy_top,dy_top,G,...
% % %         20,nu,y_top,y_tilde(3),0);
% % %     [sigma_breve_top_2,y_breve_top_2] = fault_slip_sigma_breve(ddelta_dy_top,dy_top,G,...
% % %         1,nu,y_top,xi_top,xi_top);
% % %     [sigma_breve_top_3,y_breve_top_3] = fault_slip_sigma_breve(ddelta_dy_top,dy_top,G,...
% % %         200,nu,y_top,250,y_tilde(4));
% % %     sigma_breve_plot = [sigma_breve_bot_1 sigma_breve_bot_2 sigma_breve_bot_3 ...
% % %         sigma_breve_top_1 sigma_breve_top_2 sigma_breve_top_3];
% % %     y_breve_plot = [y_breve_bot_1 y_breve_bot_2 y_breve_bot_3, ...
% % %         y_breve_top_1 y_breve_top_2 y_breve_top_3];
    [sigma_breve_bot_1a,y_breve_bot_1] = fault_slip_sigma_breve(ddelta_dy_bot,dy_bot,G,...
        200,nu,y_bot,y_tilde(1),-250); % direct terms
    [sigma_breve_bot_2a,y_breve_bot_2] = fault_slip_sigma_breve(ddelta_dy_bot,dy_bot,G,...
        1,nu,y_bot,xi_bot,xi_bot);
    [sigma_breve_bot_3a,y_breve_bot_3] = fault_slip_sigma_breve(ddelta_dy_bot,dy_bot,G,...
        20,nu,y_bot,0,y_tilde(2));   
    [sigma_breve_top_1a,y_breve_top_1] = fault_slip_sigma_breve(ddelta_dy_top,dy_top,G,...
        20,nu,y_top,y_tilde(3),0);
    [sigma_breve_top_2a,y_breve_top_2] = fault_slip_sigma_breve(ddelta_dy_top,dy_top,G,...
        1,nu,y_top,xi_top,xi_top);
    [sigma_breve_top_3a,y_breve_top_3] = fault_slip_sigma_breve(ddelta_dy_top,dy_top,G,...
        200,nu,y_top,250,y_tilde(4));
    [sigma_breve_bot_1b,~] = fault_slip_sigma_breve(ddelta_dy_top,dy_top,G,...
        200,nu,y_top,y_tilde(1),-250); % cross terms
    [sigma_breve_bot_2b,~] = fault_slip_sigma_breve(ddelta_dy_top,dy_top,G,...
        1,nu,y_top,xi_bot,xi_bot);
    [sigma_breve_bot_3b,~] = fault_slip_sigma_breve(ddelta_dy_top,dy_top,G,...
        20,nu,y_top,0,y_tilde(2));   
    [sigma_breve_top_1b,~] = fault_slip_sigma_breve(ddelta_dy_bot,dy_bot,G,...
        20,nu,y_bot,y_tilde(3),0);
    [sigma_breve_top_2b,~] = fault_slip_sigma_breve(ddelta_dy_bot,dy_bot,G,...
        1,nu,y_bot,xi_top,xi_top);
    [sigma_breve_top_3b,~] = fault_slip_sigma_breve(ddelta_dy_bot,dy_bot,G,...
        200,nu,y_bot,250,y_tilde(4));
    sigma_breve_plot =...
        [sigma_breve_bot_1a + sigma_breve_bot_1b ...
         sigma_breve_bot_2a + sigma_breve_bot_2b ...
         sigma_breve_bot_3a + sigma_breve_bot_3b ...
         sigma_breve_top_1a + sigma_breve_top_1b ...
         sigma_breve_top_2a + sigma_breve_top_2b ...
         sigma_breve_top_3a + sigma_breve_top_3b];
    y_breve_plot = [y_breve_bot_1 y_breve_bot_2 y_breve_bot_3, ...
        y_breve_top_1 y_breve_top_2 y_breve_top_3];
    
else % slip patches have merged
    % Recover grid info (see fault_slip_delta.m for definitions):
    ddelta_dy_merged = ddelta_dy(2:end-1);
    dy_merged = dy;
    xi_merged = xi;
    y_merged = y_delta(2:end-1);

    % Compute slip-induced stresses:    
    [sigma_breve_1,y_breve_1] = fault_slip_sigma_breve(ddelta_dy_merged,dy_merged,G,200,nu,...
        y_merged,y_tilde(1),-250);
    [sigma_breve_2,y_breve_2] = fault_slip_sigma_breve(ddelta_dy_merged,dy_merged,G,1,nu,...
        y_merged,xi_merged,xi_merged);
    [sigma_breve_3,y_breve_3] = fault_slip_sigma_breve(ddelta_dy_merged,dy_merged,G,200,nu,...
        y_merged,250,y_tilde(4));
    sigma_breve_plot = [sigma_breve_1 sigma_breve_2 sigma_breve_3];
    y_breve_plot = [y_breve_1 y_breve_2 y_breve_3];
end
